capture log close
clear all
macro drop _all
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\DNSP - Previous Output Weights\Stata files\TFP Analysis\Index analysis"
set more off
log using Outputs/log/anDNSP25-dnspind, replace text


/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Benchmarking AER - Previous Output Weights
Author:  Michael Cunningham
File:    anDNSP25-dnspind.do
Initial Date:    25-Jun-2022
Revised Date:  	  8-Oct-2025
--------------------------------------------------------------------------*/

scalar define rss1     = 0.0858
scalar define rss2     = 0.3376
scalar define rss3     = 0.1852
scalar define rss4     = 0.3914

local outputs energy ratchetmd customers circlength cmos
local inputs ropex overheadst overheadd undergrst undergrd transform
local costs opex auc_overheadst	auc_overheadd auc_undergrst auc_undergrd ///
	auc_transform
tempfile firmind
forvalues i = 1/14 {
	tempfile dat`i'
}
	
* Read dataset 

use Inputs/dta/dnspbench25-firm, clear
append using Inputs/dta/dnspbench25-ind
save `firmind'

* Index calculations by DNSP & total industry

forvalues z = 1/14 {
	
use `firmind', clear
keep if dnsp == `z'
sort year

*describe, fullnames
*summarize
gen ropex = opex / price_opex

* output and input quantities

local j = 1
foreach i of local outputs {
	gen q`j' = `i'
	local ++j
}

local j = 1
foreach i of local inputs {
	gen x`j' = `i'
	local ++j
}

* Input costs and cost shares

local j = 1
foreach i of local costs {
	gen c`j' = `i'
	local ++j
}
gen tc = c1 + c2 + c3 + c4 + c5 + c6

forvalues i = 1/6 {
	gen cs`i' = c`i' / tc
	gen w`i' = c`i' / x`i'
	gen lx`i' = log(x`i')
}
  

* Capital inputs only

gen kc = c2 + c3 + c4 + c5 + c6
forvalues i = 2/6 {
	gen ks`i' = c`i' / kc
}

* Output values and value shares

gen gr = revenue + price_cmos*cmos/1000
gen v5 = - price_cmos*cmos/1000
forvalues i = 1/4 {
	gen v`i' = rss`i'*gr
}

forvalues i = 1/5 {
	gen vs`i' = v`i'/ revenue
	gen p`i' = v`i'/ q`i'
	gen lq`i' = log(q`i')
}

display "Input & output weights: Industry `z'"
summarize cs1 cs2 cs3 cs4 cs5 cs6 vs1 vs2 vs3 vs4 vs5
*gen rshrtest = (r1 + r2 + r3 + r4 + r5) / revenue
*summarize rshrtest
*drop rshrtest

* Means & Lags

forvalues j = 1/6 {
	summarize lx`j', meanonly 
	scalar define lx`j'_m = r(mean)
	summarize cs`j', meanonly 
	scalar define cs`j'_m = r(mean)	
	gen lx`j'_l = lx`j'[_n-1]
	gen cs`j'_l = cs`j'[_n-1]	
}

forvalues j = 1/5 {
	summarize lq`j', meanonly 
	scalar define lq`j'_m = r(mean)
	summarize vs`j', meanonly 
	scalar define vs`j'_m = r(mean)	
	gen lq`j'_l = lq`j'[_n-1]
	gen vs`j'_l = vs`j'[_n-1]	
}

forvalues j = 2/6 {
	summarize ks`j', meanonly 
	scalar define ks`j'_m = r(mean)	
	gen ks`j'_l = ks`j'[_n-1]	
}

scalar list
describe

* Output Index

foreach k of numlist 1/5 {
	gen outdelta`k' = (vs`k' + vs`k'_m)*(lq`k' - lq`k'_m)/2 ///
			      - (vs`k'_l + vs`k'_m)*(lq`k'_l - lq`k'_m)/2
}
gen outdelta = outdelta1 + outdelta2 + outdelta3 + outdelta4 + outdelta5
gen outx = 1
replace outx = outx[_n-1] * exp(outdelta) if _n > 1 

* Input Index

foreach k of numlist 1/6 {
	gen indelta`k' = - ((cs`k' + cs`k'_m)*(lx`k' - lx`k'_m)/2 ///
			      - (cs`k'_l + cs`k'_m)*(lx`k'_l - lx`k'_m)/2)
}
gen indelta = indelta1 + indelta2 + indelta3 + indelta4 + indelta5 + indelta6
gen inx = 1
replace inx = inx[_n-1] * exp(-indelta) if _n > 1 

* TFP Index

gen tfpdelta = outdelta + indelta
gen tfpx = 1
replace tfpx = tfpx[_n-1] * exp(tfpdelta) if _n > 1 

* Opex PFP Index

gen odelta = lx1 - lx1_l
gen opinx = 1
replace opinx = opinx[_n-1] * exp(odelta) if _n > 1 
gen opfpdelta = outdelta - odelta
gen opfpx = 1
replace opfpx = opfpx[_n-1] * exp(opfpdelta) if _n > 1 

* Capital Index

foreach k of numlist 2/6 {
	gen kdelta`k' = (ks`k' + ks`k'_m)*(lx`k' - lx`k'_m)/2 ///
			      - (ks`k'_l + ks`k'_m)*(lx`k'_l - lx`k'_m)/2
}
gen kdelta = kdelta2 + kdelta3 + kdelta4 + kdelta5 + kdelta6
gen kinx = 1
replace kinx = kinx[_n-1] * exp(kdelta) if _n > 1 

* Capital PFP Index

gen kpfpdelta = outdelta - kdelta
gen kpfpx = 1
replace kpfpx = kpfpx[_n-1] * exp(kpfpdelta) if _n > 1 

* Individual output and input indexes & growth rates

forvalues j = 1/5 {
	gen outgrth`j' = log(q`j' / q`j'[_n-1]) if year > 2006
	gen q`j'x = 1
	replace q`j'x = q`j'x[_n-1] * (q`j' / q`j'[_n-1]) if year > 2006
}

forvalues i = 1/6 {
	gen ingrth`i'  = log(x`i' / x`i'[_n-1]) if year > 2006
	gen x`i'x = 1
	replace x`i'x = x`i'x[_n-1] * (x`i' / x`i'[_n-1]) if year > 2006
}

* Write results file

export excel dnsp year outx inx tfpx opinx kinx opfpx kpfpx tfpdelta ///
	outdelta indelta outdelta1 outdelta2 outdelta3 outdelta4 outdelta5 ///
	indelta1 indelta2 indelta3 indelta4 indelta5 indelta6 odelta kdelta  ///
	q1x q2x q3x q4x q5x x1x x2x x3x x4x x5x x6x outgrth1 outgrth2 outgrth3 ///
	outgrth4 outgrth5 ingrth1 ingrth2 ingrth3 ingrth4 ingrth5 ingrth6 ///
	mdindex using Outputs/xlsx/mtfp_dnspind.xlsx, sheet("`z'", replace) firstrow(var)

	save `dat`z''
}

*-------------------------------------
* Regression trends
*-------------------------------------

local varbls outx inx tfpx opfpx kpfpx 
putexcel set Outputs/xlsx/reg-trends-dnsp , modify
putexcel B3 = "Output index"
putexcel C3 = "Input index"
putexcel D3 = "TFP"
putexcel E3 = "Opex PFP"
putexcel F3 = "Capital PFP"

forvalues i = 1/14 {
	use `dat`i'', clear
	
* data management
	keep dnsp year `varbls' 
	gen tt = year - 2005
	replace tt = tt + 0.5 if (dnsp == 3 | dnsp == 8 | dnsp == 9 |dnsp == 11 ///
		|dnsp == 13) & year < 2021
	foreach k of local varbls {
		gen l`k' = log(`k')
	}

* locals, empty matrices etc

	local xlrow = `i' * 4
	local xlrow2 = `xlrow' +1
	local xlrow3 = `xlrow' +2
	local num = 1
	matrix define G = J(3,5,0)	

* regressions	
	
	foreach k of local varbls {
		
			regress l`k' tt 
			matrix G[1,`num'] = e(b)[1,1]

			regress l`k' tt if year <= 2012 
			matrix G[2,`num'] = e(b)[1,1]
		
			regress l`k' tt  if year >= 2012 
			matrix G[3,`num'] = e(b)[1,1]
			
			local ++num
		}	
	matrix list G
	putexcel B`xlrow' = matrix(G) , nformat(0.0%)
	putexcel A`xlrow' = "Growth Rate 2006–24"
	putexcel A`xlrow2' = "Growth Rate 2006–12"
	putexcel A`xlrow3' = "Growth Rate 2012–24"
	
}
putexcel save


log close
exit
